;****************************************************************************************
; Connections:
; Input:
; Pushbutton : RB0
; Output:
; 7-Segment A-G: PORTD 0-6
;hardware request:SW S6 set ON, S5 the first and second set ON,S1 ON ,S12 and S13 OFF
__CONFIG _DEBUG_OFF&_CP_OFF&_WRT_HALF&_CPD_OFF&_LVP_OFF&_BODEN_OFF&_PWRTE_OFF&_WDT_OFF&_XT_OSC
;****************************************************************************************
INCLUDE "P16F877A.INC"
;****************************************************************************************
; CBLOCK Assignments
;****************************************************************************************
CBLOCK 0X20
Delay_reg
STATUSTEMP
WREG
LOW_DIGIT ;holds the digit to be displayed on first 7_segment
HIGH_DIGIT ;holds the digit to be displayed on second 7_segment
SEC_CALC ;used in calculating the elapse of one second
START_STOP ;user defined flag which if filled with 1s the stop watch
;counts, else halts
ENDC

 PUSH macro
movwf WREG
swapf STATUS, W
movwf STATUSTEMP
endm

 POP macro
swapf STATUSTEMP , W
movwf STATUS
movf WREG, W
endm
;****************************************************************************************
ORG 0X000
GOTO MAIN
ORG 0X004
GOTO ISR
;****************************************************************************************
MAIN
CALL INITIAL
MAINLOOP
Call DisplayClock
GOTO MAINLOOP
;****************************************************************************************
INITIAL
BANKSEL TRISA    
  CLRF    TRISA           ;TRISA and TRISD are outputs
CLRF TRISD
MOVLW   01 ;RB0 as input (External Interrupt enabled), RB1-RB7 as
MOVWF TRISB ;outputs
BSF INTCON, GIE ;TMR0 and External Interrupts Enabled, their flags
;cleared
    BSF     INTCON, PEIE
BSF INTCON, INTE
BSF INTCON, TMR0IE
BCF INTCON, INTF
BCF INTCON, TMR0IF
MOVLW 0XD4 ;PSA assigned to TMR0, Prescalar = 32, TMR0 clock source
;is the internal
MOVWF OPTION_REG ;instruction cycle clock, External interrupt is on the rising
;edge
BANKSEL ADCON1
MOVLW   06H                                                    
  MOVWF   ADCON1               ;set PORTA as general Digital I/O PORT      

BANKSEL TMR0 ;TMR0 to update 256  6 = 250
MOVLW 0X06
MOVWF TMR0
CLRF LOW_DIGIT ;Initially, the number to be displayed is 00
CLRF HIGH_DIGIT
CLRF SEC_CALC ;0 ms has passed
CLRF START_STOP ;stopwatch is initially stopped
MOVLW   0FFH
  MOVWF   PORTD          
RETURN
;****************************************************************************************
ISR
PUSH
BTFSC INTCON, INTF ;External Interrupt has higher priority
CALL START_STOP_SUB
BTFSC INTCON, TMR0IF
CALL TMR0_CODE
POP
RETFIE
;****************************************************************************************

START_STOP_SUB
    BCF INTCON, INTF ;clear external interrupt flag
COMF START_STOP, F ;thus halting or starting the stopwatch.
RETURN
;****************************************************************************************
TMR0_CODE
BCF INTCON, TMR0IF ;Clear TMR0 Flag
MOVLW 0X06 ;Reinitialize TMR0
MOVWF TMR0
INCF SEC_CALC, F
MOVLW .125 ;Assuming a clock of 4MHz, we need
SUBWF SEC_CALC, W ;250 * 32 * 125 = 1x106 s = 1 Sec
BTFSS STATUS, Z
GOTO ENDTMR0 ;Not 1 Sec yet
BTFSC START_STOP, 0
CALL UPDATE_DIGITS ;if one second passed, update digits
ENDTMR0
RETURN
;****************************************************************************************
UPDATE_DIGITS
CLRF SEC_CALC ;Cleared so as to count the next 1 sec correctly
MOVF LOW_DIGIT, W ;If previous low digit is not 9, increment low digit by one
SUBLW 0X09 ;else, increment high digit by one and clear low digit
BTFSC STATUS, Z
GOTO UPDATE_HIGH_DIGIT
GOTO UPDATE_LOW_DIGIT
END_UPDATE
CALL DisplayClock ;Update clock display
RETURN
;****************************************************************************************
UPDATE_LOW_DIGIT
INCF LOW_DIGIT, F
GOTO END_UPDATE
UPDATE_HIGH_DIGIT
CLRF LOW_DIGIT
INCF HIGH_DIGIT, F
MOVF HIGH_DIGIT, W
SUBLW 6 ; if high digit reaches 6 (that is number = 60, 1 Minute),
BTFSC STATUS, Z ;reset
CLRF HIGH_DIGIT
GOTO END_UPDATE
;****************************************************************************************
DisplayClock
MOVF   LOW_DIGIT, W                                    
  CALL    Look_TABLE                                                
  MOVWF   PORTD                                                  
  BCF     PORTA,1                  ;enable first 7_segment display                              
  CALL    DELAY                                                  
  BSF     PORTA,1                                                
                                                               
  MOVF   HIGH_DIGIT, W                    
  CALL    Look_TABLE
MOVWF   PORTD
  BCF     PORTA,0 ;enable second 7_segment display
  CALL    DELAY
BSF     PORTA,0

RETURN
;****************************************************************************************
Look_TABLE
ADDWF   PCL, 1
RETLW B'11000000' ;'0'
RETLW B'11111001' ;'1'
RETLW B'10100100' ;'2'
RETLW B'10110000' ;'3'
RETLW B'10011001' ;'4'
RETLW B'10010010' ;'5'
RETLW B'10000010' ;'6'
RETLW B'11111000' ;'7'
RETLW B'10000000' ;'8'
RETLW B'10010000' ;'9'
;**************delay subprogram*****************************
DELAY
  MOVLW   0FFH
  MOVWF   Delay_reg
L1 DECFSZ  Delay_reg,F
  GOTO    L1
  RETURN

END